import 'package:firebase_analytics/firebase_analytics.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'blocs/theme_bloc.dart';
import 'blocs/font_size_bloc.dart';
import 'package:easy_localization/easy_localization.dart';
import 'models/theme.dart';
import 'pages/splash.dart';

final FirebaseAnalytics firebaseAnalytics = FirebaseAnalytics.instance;
final FirebaseAnalyticsObserver firebaseObserver =
    FirebaseAnalyticsObserver(analytics: firebaseAnalytics);

class MyApp extends ConsumerWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final themeMode = ref.watch(themeBlocProvider);
    final fontSizeBloc = ref.watch(fontSizeBlocProvider);
    return MediaQuery(
      data: MediaQueryData.fromView(
              WidgetsBinding.instance.platformDispatcher.views.first)
          .copyWith(
        textScaler: TextScaler.linear(fontSizeBloc.textScaleFactor),
      ),
      child: MaterialApp(
        debugShowCheckedModeBanner: false,
        supportedLocales: context.supportedLocales,
        localizationsDelegates: context.localizationDelegates,
        navigatorObservers: [firebaseObserver],
        locale: context.locale,
        theme: ThemeModel().lightTheme,
        darkTheme: ThemeModel().darkTheme,
        themeMode:
            themeMode.darkTheme == true ? ThemeMode.dark : ThemeMode.light,
        home: const SplashPage(),
      ),
    );
  }
}
